﻿//NINA.jsx
// Więcej informacji o kształtach NINA znaleźć można na stronie:
//http://www.washington.edu/bibsys/mattf/nina/index.html
// myNumberOfLines wyznacza ilość linii w tworzonym kształcie NINA.
var myNumberOfLines = 201;
// Eksperymentując z wartościami zmiennych a_pulse i b_pulse tworzyć można różne // kształty.
// wartości wspomnianych zmiennych nie mogą być większe niż wartość myNumberOfLines
var a_pulse = 161;
var b_pulse = 16;
// zmienna myLenght kontroluje długość linii; promień kształtu jest mniej więcej równy
// dwukrotności tej zmiennej.
var myLength = 36;
// Aby zamknąć kształt, należy przypisać zmiennej myClosedPath wartość true.
// Jeśli ścieżka ma pozostać otwarta, wspomnianej zmiennej należy przypisać wartość   false.
var myClosedPath = true;
if(app.documents.length != 0){
if(app.activeWindow.constructor.name == "LayoutWindow"){
var myViewPreferences = app.activeDocument.viewPreferences;
var myOldXUnits = myViewPreferences.horizontalMeasurementUnits;
var myOldYUnits = myViewPreferences.verticalMeasurementUnits;
app.activeDocument.viewPreferences.horizontalMeasurementUnits =
MeasurementUnits.points;
app.activeDocument.viewPreferences.verticalMeasurementUnits =
MeasurementUnits.points;
myDrawNina(myNumberOfLines, a_pulse, b_pulse, myLength,
myClosedPath);
app.activeDocument.viewPreferences.horizontalMeasurementUnits =
myOldXUnits;
app.activeDocument.viewPreferences.verticalMeasurementUnits =
myOldYUnits;
}
}
function myDrawNina(myNumberOfLines, a_pulse, b_pulse, myLength,
myClosedPath){
var cur_x, cur_y;
var myAnchor = new Array(2);
var myArray = new Array;
// Zamiast rysować całą ścieżkę punkt po punkcie,
// utworzymy tablicę zawierającą współrzędne punktów
// za pomocą właściwości entirePath.
for (var myCounter = 0; myCounter < myNumberOfLines; myCounter++){
cur_x = (Math.cos((-2 * Math.PI * a_pulse * myCounter) /
myNumberOfLines) + Math.cos((-2 * Math.PI * b_pulse * myCounter)
/ myNumberOfLines)) * myLength;
cur_y = (Math.sin((-2 * Math.PI * a_pulse * myCounter) /
myNumberOfLines) + Math.sin((-2 * Math.PI * b_pulse * myCounter)
/ myNumberOfLines)) * myLength;
myAnchor = [cur_x, cur_y];
myArray.push(myAnchor);
}
app.activeDocument.viewPreferences.horizontalMeasurementUnits =
MeasurementUnits.points;
app.activeDocument.viewPreferences.verticalMeasurementUnits =
MeasurementUnits.points;
var myPage = app.activeWindow.activePage;
var myGraphicLine = myPage.graphicLines.add();
myGraphicLine.move(undefined, ["1p","1p"]);
var myPath = myGraphicLine.paths.item(0);
//Tworzymy ścieżkę w oparciu o zawartość tablicy
myPath.entirePath = myArray;
if(myClosedPath == true){
myPath.pathType = PathType.closedPath;
}
else{
myPath.pathTYpe = PathType.openPath;
}
//Dodajemy opis ustawień wykorzystanych do utworzenia grafiki.
myGraphicLine.label = "number_of_lines = " + myNumberOfLines + 
", a_pulse = " + a_pulse + ", b_pulse = " + b_pulse;
}